/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jclass.datasource.ColumnModel;
import jclass.datasource.DataModel;
import jclass.datasource.DataModelException;
import jclass.datasource.DataTableModel;
import jclass.datasource.LocaleBundle;
import jclass.datasource.MetaDataModel;
import jclass.datasource.treemodel.TreeNode;

public class BaseMetaData
extends TreeNode
implements MetaDataModel {
    static final long serialVersionUID = 11333618763573765L;
    DataModel dataModel;
    String description = "";
    Hashtable insertPermissions;
    Hashtable updatePermissions;
    Hashtable deletePermissions;
    Hashtable idxToColumnMap;
    Vector columns = new Vector();
    int commitPolicy = 1;
    Class storeClass;
    protected int initialHashtableSize = 5;
    private int metaDataID;
    private static int counter;
    private int maxRows;
    private boolean cacheChildren = false;
    private boolean showDeletedRows = true;
    transient DataTableModel currentDataTable;
    long currentBookmark = -1L;
    int bufferSize = 5000;

    public BaseMetaData(DataModel dataModel) {
        super(null);
        this.dataModel = dataModel;
        this.metaDataID = counter++;
        this.insertPermissions = new Hashtable(this.initialHashtableSize);
        this.updatePermissions = new Hashtable(this.initialHashtableSize);
        this.deletePermissions = new Hashtable(this.initialHashtableSize);
        this.idxToColumnMap = new Hashtable(this.initialHashtableSize);
    }

    public void setInsertAllowed(String string, boolean bl) {
        if (this.insertPermissions.containsKey(string)) {
            this.insertPermissions.remove(string);
        }
        this.insertPermissions.put(string, new Boolean(bl));
    }

    public void setUpdateAllowed(String string, boolean bl) {
        if (this.updatePermissions.containsKey(string)) {
            this.updatePermissions.remove(string);
        }
        this.updatePermissions.put(string, new Boolean(bl));
    }

    public void setDeleteAllowed(String string, boolean bl) {
        if (this.deletePermissions.containsKey(string)) {
            this.deletePermissions.remove(string);
        }
        this.deletePermissions.put(string, new Boolean(bl));
    }

    public boolean getInsertAllowed(String string) {
        if (string == null) {
            return true;
        }
        if (this.insertPermissions.get(string) != null) {
            return (Boolean)this.insertPermissions.get(string);
        }
        return true;
    }

    public boolean getUpdateAllowed(String string) {
        if (string == null) {
            return true;
        }
        if (this.updatePermissions.get(string) != null) {
            return (Boolean)this.updatePermissions.get(string);
        }
        return true;
    }

    public boolean getDeleteAllowed(String string) {
        if (string == null) {
            return true;
        }
        if (this.deletePermissions.get(string) != null) {
            return (Boolean)this.deletePermissions.get(string);
        }
        return true;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public int getMetaID() {
        return this.metaDataID;
    }

    public void setMetaID(int n) {
        this.metaDataID = n;
        counter = n + 1;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean getAutoCommit() throws DataModelException {
        return true;
    }

    public void setAutoCommit(boolean bl) throws DataModelException {
    }

    public void rollbackTransaction() throws Exception {
    }

    public void commitTransaction() throws Exception {
    }

    public void setCommitPolicy(int n) throws DataModelException {
        if (!this.getShowDeletedRows() && n == 1) {
            Exception exception = new Exception(LocaleBundle.string("setShowDeletedRows cannot be false if commit policy is COMMIT_LEAVING_RECORD"));
            throw new DataModelException(107, exception);
        }
        this.commitPolicy = n;
    }

    public int getCommitPolicy() {
        return this.commitPolicy;
    }

    public Vector getColumnObjects() {
        return this.columns;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public void addColumn(ColumnModel columnModel) throws DataModelException {
        Enumeration enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            ColumnModel columnModel2 = (ColumnModel)enumeration.nextElement();
            if (columnModel2.getIdentifier() == null || !columnModel2.getIdentifier().equals(columnModel.getIdentifier())) continue;
            String string = String.valueOf(LocaleBundle.string("Duplicate columns not allowed. Use aliasing. Column: ")) + columnModel2.getIdentifier();
            throw new DataModelException(107, new Exception(string));
        }
        this.columns.addElement(columnModel);
        this.getColumnMap().put(columnModel.getIdentifier(), new Integer(this.columns.size() - 1));
    }

    public String getColumnIdentifier(int n) throws DataModelException {
        return ((ColumnModel)this.columns.elementAt(n)).getIdentifier();
    }

    public int getJavaColumnType(String string) throws DataModelException {
        return this.getColumnObject(string).getMetaColumnType();
    }

    public ColumnModel getColumnObject(String string) throws DataModelException {
        return (ColumnModel)this.getColumnObjects().elementAt(this.getColumnIndex(string));
    }

    public int getColumnIndex(String string) throws DataModelException {
        if (!this.getColumnMap().containsKey(string)) {
            Exception exception = new Exception(String.valueOf(LocaleBundle.string("Column not found: ")) + string);
            throw new DataModelException(107, exception);
        }
        return (Integer)this.idxToColumnMap.get(string);
    }

    public Hashtable getColumnMap() {
        return this.idxToColumnMap;
    }

    public Object getNativeMetaData() {
        return null;
    }

    public boolean isUpdateAllowedOnColumn(String string) throws DataModelException {
        try {
            ColumnModel columnModel = this.getColumnObject(string);
            if (columnModel == null || columnModel.getTableName() == null || columnModel.getTableName().equals("")) {
                return true;
            }
            return this.getUpdateAllowed(columnModel.getTableName());
        }
        catch (Exception exception) {
            throw new DataModelException(4, exception);
        }
    }

    public void clear() {
        this.idxToColumnMap.clear();
        this.columns.removeAllElements();
        this.setCurrentBookmark(-1L);
    }

    public void setShowDeletedRows(boolean bl) throws DataModelException {
        if (!bl && this.getCommitPolicy() == 1) {
            Exception exception = new Exception(LocaleBundle.string("setShowDeletedRows cannot be false if commit policy is COMMIT_LEAVING_RECORD"));
            throw new DataModelException(107, exception);
        }
        this.showDeletedRows = bl;
    }

    public boolean getShowDeletedRows() {
        return this.showDeletedRows;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setCacheChildren(boolean bl) {
        this.cacheChildren = bl;
    }

    public boolean getCacheChildren() {
        return this.cacheChildren;
    }

    public DataTableModel getCurrentDataTable() {
        return this.currentDataTable;
    }

    public long getCurrentBookmark() {
        try {
            DataTableModel dataTableModel;
            if (this.currentBookmark == -1L && (dataTableModel = this.getCurrentDataTable()) != null && dataTableModel.getRowCount() > 0) {
                dataTableModel.first();
                this.setCurrentBookmark(dataTableModel.getCurrentBookmark());
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return this.currentBookmark;
    }

    public void setCurrentDataTable(DataTableModel dataTableModel) {
        this.currentDataTable = dataTableModel;
    }

    public void setCurrentBookmark(long l) {
        this.currentBookmark = l;
    }

    public byte[] createByteArrayFromBinaryStream(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return null;
        }
        if (inputStream.markSupported()) {
            inputStream.reset();
        }
        byte[] byArray = new byte[this.getBufferSize()];
        byte[] byArray2 = new byte[this.getBufferSize()];
        int n = 0;
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) > 0) {
            byte[] byArray3 = byArray2;
            byArray2 = new byte[n + n2];
            System.arraycopy(byArray3, 0, byArray2, 0, n);
            System.arraycopy(byArray, 0, byArray2, n, n2);
            n += n2;
        }
        return byArray2;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setStoreClass(String string) throws DataModelException {
        try {
            this.storeClass = Class.forName(string);
            return;
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public Class getStoreClass() throws DataModelException {
        if (this.storeClass == null) {
            this.setStoreClass("jclass.datasource.Store");
        }
        return this.storeClass;
    }
}

